//OHSAT GAMES TUTORIAL: MEGALAGA 3 BONUS: Enemies
//Wasn't sure if I wanted to use a Fozzy reference or Ebony & Ivory reference
//but I couldn't make either work so you get nothing, sir!  

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>

// Declarations

#define ANIM_WALK 0
#define ANIM_JUMP 1
#define ANIM_IDLE 2
#define ANIM_DMG 3
#define ANIM_ATK 4
#define ANIM_WAND 5
#define ANIM_DUCK 6
#define ANIM_DIE 7
#define ANIM_SWIM 8
#define ANIM_SATK 9

#define MAX_ENEMIES 6

int offset = 0;
int i = 0; 
u16 enemiesLeft = 0;

typedef struct {
	int x;
	int y;
	int w;
	int h;
	int velx;
	int vely;
	int health;
	Sprite* sprite;
	char name[8];
} Entity;

Entity player = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER" };
Entity player_2 = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER 2" };
Entity enemies[MAX_ENEMIES];


void killEntity(Entity* e);
void reviveEntity(Entity* e);

int main()
{
    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);  // Load tile set at index 1
    PAL_setPalette(PAL1, background.palette->data, DMA);  
    PAL_setPalette(PAL2, background.palette->data, DMA);  
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    PAL_setColor(34,RGB24_TO_VDPCOLOR(0x0078f8));
    SYS_enableInts();

    SPR_init();

    /*Add the player*/
    player.x = 152;
    player.y = 192;
    player.health = 1;
    player.sprite = SPR_addSprite(&ship,player.x,player.y,TILE_ATTR(PAL1,0,FALSE,FALSE));

    /*Add the player 2*/
    player_2.x = 100;
    player_2.y = 192;
    player_2.health = 1;
    player_2.sprite = SPR_addSprite(&ship1, player_2.x,player_2.y,TILE_ATTR(PAL1,0,FALSE,FALSE));

    SPR_update();

    int thex = 0;
    int they = 0;
    int val = 1;

    // Fill the background with random tiles
    for (int i = 0; i < 1280; i++)  // 40x32 = full screen + buffer
    {   
        
        int thex = i % 40;
        int they = i / 40;

        // Randomly choose between blank (0), star1 (1), or star2 (2)
        int val = (random() % (10 - 1 + 1)) + 1;  // 0, 1, or 2
        if(val > 3) val = 1;
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, val), thex, they);
    }


    /*Create all enemy sprites*/
    Entity* e = enemies;
    for(i = 0; i < MAX_ENEMIES; i++){
        
        
        e->x = i*32;
        e->y = 32;
        e->w = 16;
        e->h = 16;
        e->velx = 1;
        e->health = 1;

        e->sprite = SPR_addSprite(&ship,e->x,e->y,TILE_ATTR(PAL2,0,TRUE,FALSE));
        sprintf(e->name, "En%d",i);
        enemiesLeft++;
        e++;
    }

    /*Create second row of enemy sprites with nemo_sprite from right to left*/
    for(i = 0; i < MAX_ENEMIES; i++){
        Entity* e2 = &enemies[i]; // reuse the existing enemies array, or create a new one if needed
        int x = 320 - (i * 32);   // right to left (assuming screen width ~320)
        int y = 64;               // one row below the first enemy row at y = 32

        e2->x = x;
        e2->y = y;
        e2->w = 16;
        e2->h = 16;
        e2->velx = -1;           // Optional: reverse direction
        e2->health = 1;

        e2->sprite = SPR_addSprite(&nemo_sprite, e2->x, e2->y, TILE_ATTR(PAL2, 0, TRUE, FALSE));
        SPR_setAnim(e2->sprite, ANIM_DIE); // Set default animation to ANIM_DIE
        sprintf(e2->name, "Nm%d", i);
        enemiesLeft++;
    }

    while (1)
    {
        // Scroll the background vertically
        VDP_setVerticalScroll(BG_B, offset -= 2);
        if (offset <= -256) offset = 0;

        SPR_update();
        SYS_doVBlankProcess();
    }

    return 0;
}

//////Functions///////

void killEntity(Entity* e){
	e->health = 0;
	SPR_setVisibility(e->sprite,HIDDEN);
}

void reviveEntity(Entity* e){
	e->health = 1;
	SPR_setVisibility(e->sprite,VISIBLE);
}

////////////////////NOTES////////////////////

/*

Note: I added the lines of code from the previous bonus lesson to add a 2nd player sprite. 
Also, we're going to use the same enemy array as the first row of enemies we added. 

This time we're just going to reuse a lot of existing code and tweak it to work for our 2nd enemy sprite. 

    for(i = 0; i < MAX_ENEMIES; i++){
        Entity* e2 = &enemies[i]; // reuse the existing enemies array, or create a new one if needed
        int x = 320 - (i * 32);   // right to left (assuming screen width ~320)
        int y = 64;               // one row below the first enemy row at y = 32

        e2->x = x;
        e2->y = y;
        e2->w = 16;
        e2->h = 16;
        e2->velx = -1;           // Optional: reverse direction
        e2->health = 1;

        e2->sprite = SPR_addSprite(&nemo_sprite, e2->x, e2->y, TILE_ATTR(PAL2, 0, TRUE, FALSE));
        SPR_setAnim(e2->sprite, ANIM_DIE); // Set default animation to ANIM_DIE
        sprintf(e2->name, "Nm%d", i);
        enemiesLeft++;
    }

We're reusing the same for() statement but the variables inside are modified to account for 
different positioning on screen and the fact that we're using a different sprite w/ included animation. 
The code is commented out to explain the changes. However, I recommend going line-by-line and comparing
e-> and e2-> code to see if you understand the changes that are being made. 

    Entity* e = enemies;
    for(i = 0; i < MAX_ENEMIES; i++){
        
        
        e->x = i*32;
        e->y = 32;
        e->w = 16;
        e->h = 16;
        e->velx = 1;
        e->health = 1;

        e->sprite = SPR_addSprite(&ship,e->x,e->y,TILE_ATTR(PAL2,0,TRUE,FALSE));
        sprintf(e->name, "En%d",i);
        enemiesLeft++;
        e++;
    }

Property	e-> (original row)	        e2-> (new row)

x position	i * 32 (left to right)	    320 - (i * 32) (right to left)
y position	32	                        64 (one row below)
sprite	ship	                        nemo_sprite
animation	none set	                SPR_setAnim(e2->sprite, ANIM_DIE)
velocity	velx = 1	                velx = -1 (optional for leftward motion)
name format	"En%d"	"                   Nm%d"
array used	enemies[i]	                (same) enemies[i] or (new) enemies_nemo[i]

Note: If we want to use a separate enemy array, we just need to change the following: 

Current code: Entity* e2 =&enemies[i]; 
Replacement code: Entity* e2 =&enemies_nemo[i];  





*/

/////////EXPERIMENTATION IDEAS///////////////

/*

Let's add a second row of enemies. 

*/

///////////ERROR HANDLING////////////////////
/*

*/